/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.wizard.update;

import DE.siemens.ad.logo.dialog.wizard.WizardInputPanel;
import DE.siemens.ad.logo.dialog.wizard.WizardModel;
import DE.siemens.ad.logo.dialog.wizard.WizardPanelModel;
import DE.siemens.ad.logo.dialog.wizard.update.ModuleInfo;
import DE.siemens.ad.logo.dialog.wizard.update.SelectModulesModel;
import DE.siemens.ad.logo.dialog.wizard.update.SelectUpdateDirectoryPanel;
import DE.siemens.ad.logo.dialog.wizard.update.SelectUpdateFilesModel;
import DE.siemens.ad.logo.dialog.wizard.update.UpdateWizardModel;
import DE.siemens.ad.logo.util.LogoIOException;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SelectUpdateDirectoryModel
extends WizardPanelModel {
    protected SelectUpdateDirectoryPanel selectUpdateDirectoryPanel = new SelectUpdateDirectoryPanel(this);
    protected String lastDirectory;
    protected String updateDirectory;
    public static final String NO_CATALOG_FILE_FOUND = "not catalog file found";
    protected SelectUpdateFilesModel selectUpdateFileModel;
    protected SelectModulesModel selectModulesModel;

    public SelectUpdateDirectoryModel(WizardModel wizardModel) {
        super(wizardModel);
        this.selectModulesModel = new SelectModulesModel(wizardModel);
        this.selectUpdateFileModel = new SelectUpdateFilesModel(wizardModel);
        this.nextPanelModel = this.selectModulesModel;
    }

    protected Vector findLufFiles(File updateDirectory) {
        Vector<File> lufFiles = new Vector<File>();
        File[] files = updateDirectory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].getName().toLowerCase().endsWith(".luf") && !files[i].getName().toLowerCase().endsWith(".luf.zip")) continue;
            lufFiles.add(files[i]);
        }
        return lufFiles;
    }

    public String getLastDirectory() {
        return this.lastDirectory;
    }

    public Vector getModules(Vector lufFiles) {
        Enumeration e = lufFiles.elements();
        Vector<ModuleInfo> modules = new Vector<ModuleInfo>();
        ModuleInfo module = null;
        File lufFile = null;
        while (e.hasMoreElements()) {
            lufFile = (File)e.nextElement();
            try {
                module = this.parseFile(lufFile);
                module.setFilename(lufFile.getName());
                Version currentProgramVersion = Version.getCurrentVersion();
                if (module.validFromVersion.compareTo(currentProgramVersion) < 1 && module.validToVersion.compareTo(currentProgramVersion) > -1 && module.applicableToVersion(currentProgramVersion) && (module.processorArchitecture.compareTo(System.getProperty("sun.arch.data.model")) == 0 || module.processorArchitecture.compareTo("all") == 0)) {
                    modules.add(module);
                }
                module.setSize((int)lufFile.length());
            }
            catch (Exception ex) {}
        }
        return modules;
    }

    public String getUpdateDirectory() {
        return this.updateDirectory;
    }

    public WizardInputPanel getWizardInputPanel() {
        return this.selectUpdateDirectoryPanel;
    }

    public void loadData() {
        LogoProperties props = LogoProperties.instance();
        this.lastDirectory = props.getProperty("update.selectUpdateFile.lastDirectory");
    }

    protected ModuleInfo parseFile(File file) throws Exception {
        ModuleInfo moduleInfo = null;
        BufferedReader br = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            ZipEntry moduleInfoEntry = zipFile.getEntry("moduleinfo.dat");
            br = new BufferedReader(new InputStreamReader(zipFile.getInputStream(moduleInfoEntry)));
            String line = null;
            while ((line = br.readLine()) != null && line.startsWith("#")) {
            }
            if (line == null) {
                throw new IOException("No moduleinfo found.");
            }
            moduleInfo = new ModuleInfo(line);
            moduleInfo.setLocalSourceDirectory(file.getAbsolutePath());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            br.close();
            zipFile.close();
        }
        return moduleInfo;
    }

    public Object process() throws Exception {
        File updateDirectoryFile = new File(this.updateDirectory);
        File catalogFile = new File(this.updateDirectory, "/catalog.dat");
        if (!catalogFile.exists()) {
            Vector lufFiles = this.findLufFiles(updateDirectoryFile);
            if (lufFiles.isEmpty()) {
                throw new LogoIOException(NO_CATALOG_FILE_FOUND, "No catalog file with update information found");
            }
            ((UpdateWizardModel)this.wizardModel).setURL(updateDirectoryFile.toURL().toString());
            ((UpdateWizardModel)this.wizardModel).setAvailableModules(this.getModules(lufFiles));
        } else {
            BufferedReader br = new BufferedReader(new FileReader(catalogFile));
            StringBuffer catalogInformation = new StringBuffer();
            String currentLine = "";
            while ((currentLine = br.readLine()) != null) {
                catalogInformation.append(currentLine);
                catalogInformation.append("\n");
            }
            ((UpdateWizardModel)this.wizardModel).setURL(updateDirectoryFile.toURL().toString());
            ((UpdateWizardModel)this.wizardModel).setCatalogFile(catalogInformation.toString());
            ((UpdateWizardModel)this.wizardModel).parseCatalogFile();
        }
        return Boolean.TRUE;
    }

    public void setUpdateDirectory(String newUpdateDirectory) {
        this.updateDirectory = newUpdateDirectory;
        this.lastDirectory = newUpdateDirectory;
    }

    public void storeData() {
        LogoProperties props = LogoProperties.instance();
        props.setProperty("update.selectUpdateFile.lastDirectory", this.lastDirectory);
        props.saveProperties();
    }
}

